
#ifndef APPLEDISKII_H
#define APPLEDISKII_H

#include "EmuApple.h"

const int NUM_DRIVES = 2;
const int NUM_TRACKS = 35;
const int TRACK_SIZE = 0x18f8;
const int SECTOR_SIZE = 383;

typedef byte TAppleRawTrack[TRACK_SIZE];
typedef byte TAppleCookedTrack[0x1000];

class TAppleDiskProvider
{
public:
	virtual void getTrackData(int track, byte* data) = 0;
	virtual void setTrackData(int track, byte* data) = 0;
	virtual int getIsWriteProtected() = 0;
};

class TAppleDrive
{
public:
	int track;
	int track_index;
	int track_read;
	TAppleRawTrack track_data;
	boolean write_mode, write_protect, track_is_dirty;
	TAppleDiskProvider* diskprovider;

	TAppleDrive();

	int getCurrentTrack() { return track; }
	int getTrackIndex() { return track_index; }
	boolean getIsWriteMode() { return write_mode; }
	boolean getIsWriteProtect() { return write_protect; }
	void setDiskProvider(TAppleDiskProvider* dp) { diskprovider = dp; }
	TAppleDiskProvider* getDiskProvider() { return diskprovider; }
	void setTrack(int newtrack);
	void setNewDisk(); 
	void ensureValidData();
};

class TAppleDiskII : public TApplePeripheral
{
	TAppleDrive drive[2];
	int curdrive;			// current drive
	TAppleDrive* d;
	boolean flag;		// crazy flag
	boolean motor;		// is motor on?
	byte data_latch, address_latch;

	int read_nibble();
	void write_nibble(int value);

public:
	TAppleDiskII(TAppleII* apple);
	int doIO(int address, int value);
	int doHighIO(int address, int value);
	TAppleDrive* getCurrentDrive() { return d; }
	TAppleDrive* getDrive(int driveindex) { return &drive[driveindex]; }
	boolean isMotorOn() { return motor; }
};

#endif
